
markup.push({

	// MARK: balance

	BalanceBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Balance",
		geNodeClass: "AHBalanceNode",
		h4PresetsId: "BalancePresets",
		gxPopoverInfo: "BalancePopover",
		gxLibraryDescription: "Adjust relative volumes of left and right channels",
		gxLibraryIcon: "library.balance",
		gxDescriptionKeyPath: "node.balance",
		gxDescriptionFormatter: "LeftRightFormatter",
		geImporterParams: ["node.importBalance"],
		gxChildViews:
		{
			balance: {
				"+": "SliderView.blockFace.trackUnfilled",
				gxValueKey: "node.balance",
				gxRangeMin: -1,
				gxRangeMax: 1,
				gxDetents: "0",
				gxKeystrokeStepSize: 0.01,
				axTitle: "Balance",
				axFormatter: "PercentFormatter",
				axHelp: "Negative % is Left, Positive is Right",
			},
			readout: {
				"+": "LabelView.blockReadout",
				gxFrameRect: "18,66,83,25",
				gxValueKey: "node.balance",
				gxFormatter: "LeftRightFormatter"
			}
		}
	},

	// MARK: popover

	BalancePopover: {
		"+": "PopoverTemplate",
		gxTitle: "Balance",
		gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-8-[presetsGroup]"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			group:
			{
				"+": "GroupView",
				gxLayout: [
					"H:|-0-[self]-0-|",
					"H:|-12-[balance]-12-|",
					"V:|-30-[balance]-16-|",

					"V:[leftLabel]-(-1)-[balance]&alignLeft",
					"V:[balanceReadout]-(-1)-[balance]&alignCenterX",
					"V:[rightLabel]-(-1)-[balance]&alignRight",
				],
				gxChildViews:
				{
					balance: {
						"+": "SliderView.trackUnfilled",
						gxValueKey: "node.balance",
						gxRangeMin: -1,
						gxRangeMax: 1,
						gxDetents: "0",
						gxKeystrokeStepSize: 0.01,
						axTitle: "Balance",
						axFormatter: "PercentFormatter",
						axHelp: "Negative % is Left, Positive is Right",
					},
					leftLabel: labelView("L", "size12"),
					rightLabel: labelView("R", "right.size12"), // "Right", right aligned
					balanceReadout: {
						"+": "ReadoutView.centerx",
						gxIntrinsicWidth: 100,
						gxValueKey: "node.balance",
						gxFormatter: "LeftRightFormatter.fullWords"
					}
				}
			}
		}
	},
		
})
